#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_PatientData
	{
		[SetUp]
		protected void SetUp()
		{
			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetVistaPatientData_Pass()
		{
			Assert.IsTrue( DAL.VAL.PatientData.GetVistaPatientData( "AN", String.Empty, String.Empty ).Rows.Count > 0 );

			//Code Coverage - Pseduo SSN
			Assert.IsTrue( DAL.VAL.PatientData.GetVistaPatientData( String.Empty, "709073164", String.Empty ).Rows.Count > 0 );
		}

		[Test]
		public void GetVistaPatientData_Pass_2()
		{
			Assert.IsNotNull( DAL.VAL.PatientData.GetVistaPatientData( String.Empty, String.Empty, String.Empty ) );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetVistaPatientData_Fail()
		{
			DAL.VAL.PatientData.GetVistaPatientData( null, String.Empty, String.Empty );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetVistaPatientData_Fail_2()
		{
			DAL.VAL.PatientData.GetVistaPatientData( String.Empty, null, String.Empty );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetVistaPatientData_Fail_3()
		{
			DAL.VAL.PatientData.GetVistaPatientData( String.Empty, String.Empty, null );
		}

		[Test]
		public void GetVistaPatientData_Pass_3()
		{
			DataTable dt = DAL.VAL.PatientData.GetVistaPatientData( "AAHPHAANY,ILQDI", String.Empty, String.Empty );
			Assert.IsNotNull( dt.Rows[0]["PatientDeathDate"] );
		}

		[Test]
		public void GetVistaPatientData_Pass_4()
		{
			Assert.IsNotNull( DAL.VAL.PatientData.GetVistaPatientData( string.Empty, "5740", string.Empty) );
		}

		[Test]
		public void GetVistaPatientData_Pass_5()
		{
			Assert.IsNotNull( DAL.VAL.PatientData.GetVistaPatientData( "A", "5740", string.Empty) );
		}

		[Test]
		public void GetVistaPatientData_Pass_6()
		{
			Assert.IsNotNull( DAL.VAL.PatientData.GetVistaPatientData( string.Empty, "582355740", string.Empty) );
		}

	}
}
#endif
